#include "clipboardmonitor.h"
#include "settings.h"
#include "urlchecker.h"
#if QT_VERSION >= 0x050000
#include <QGuiApplication>
#else
#include <QApplication>
#endif
#include <QClipboard>
#ifdef MEEGO_EDITION_HARMATTAN
#include <QTimer>
#endif

ClipboardMonitor* ClipboardMonitor::m_instance = 0;

ClipboardMonitor::ClipboardMonitor() :
    QObject()
  #ifdef MEEGO_EDITION_HARMATTAN
  ,m_timer(0)
  #endif
{
    if (!m_instance) {
        m_instance = this;
    }

    this->connect(Settings::instance(), SIGNAL(monitorClipboardChanged(bool)), this, SLOT(onMonitorClipboardChanged(bool)));
    this->onMonitorClipboardChanged(Settings::instance()->monitorClipboard());
}

ClipboardMonitor::~ClipboardMonitor() {}

ClipboardMonitor* ClipboardMonitor::instance() {
    return !m_instance ? new ClipboardMonitor : m_instance;
}

void ClipboardMonitor::onMonitorClipboardChanged(bool monitor) {
#if QT_VERSION >= 0x050000
    if (monitor) {
        this->connect(QGuiApplication::clipboard(), SIGNAL(dataChanged()), this, SLOT(onClipboardTextChanged()));
    }
    else {
        this->disconnect(QGuiApplication::clipboard(), SIGNAL(dataChanged()), this, SLOT(onClipboardTextChanged()));
    }
#else
    if (monitor) {
        this->connect(QApplication::clipboard(), SIGNAL(dataChanged()), this, SLOT(onClipboardTextChanged()));
    }
    else {
        this->disconnect(QApplication::clipboard(), SIGNAL(dataChanged()), this, SLOT(onClipboardTextChanged()));
    }
#endif
}

void ClipboardMonitor::onClipboardTextChanged() {
#ifdef MEEGO_EDITION_HARMATTAN
    if ((m_timer) && (m_timer->isActive())) {
        // QClipboard::dataChanged() signal is emitted twice in Harmattan, so ignore the signal if the timer is still active.
        return;
    }
    else {
        if (!m_timer) {
            m_timer = new QTimer(this);
            m_timer->setInterval(3000);
            m_timer->setSingleShot(true);
        }

        m_timer->start();
    }
#endif
#if QT_VERSION >= 0x050000
    if (QGuiApplication::clipboard()->text().startsWith("http")) {
        emit clipboardUrlsReady(QGuiApplication::clipboard()->text());
    }
#else
    if (QApplication::clipboard()->text().startsWith("http")) {
        emit clipboardUrlsReady(QApplication::clipboard()->text());
    }
#endif
}
