#ifndef CATEGORIESMODEL_H
#define CATEGORIESMODEL_H

#include <QAbstractTableModel>

class CategoriesModel : public QAbstractTableModel
{
    Q_OBJECT

    Q_PROPERTY(int count
               READ rowCount
               NOTIFY countChanged)

public:
    enum Roles {
        NameRole = Qt::UserRole + 1,
        PathRole
    };

public:
    explicit CategoriesModel(QObject *parent = 0);
    ~CategoriesModel();
#if QT_VERSION >= 0x050000
    QHash<int, QByteArray> roleNames() const;
#endif
    int rowCount(const QModelIndex &parent = QModelIndex()) const;
    int columnCount(const QModelIndex &parent = QModelIndex()) const;
    QVariant headerData(int section, Qt::Orientation orientation, int role) const;
    QVariant data(const QModelIndex &index, int role) const;
#if QT_VERSION >= 0x040600
    Q_INVOKABLE QVariant data(int row, const QByteArray &role) const;
#endif
    Q_INVOKABLE void loadCategories();

public slots:
    void addCategory(const QString &name, const QString &path);
    void removeCategory(const QString &name);
    void removeCategory(int row);

signals:
    void countChanged(int count);

private:
    QList< QPair<QString, QString> > m_list;
#if QT_VERSION >= 0x040600
    QHash<int, QByteArray> m_roleNames;
#endif
};

#endif // CATEGORIESMODEL_H
