#include "valueselector.h"
#include "../shared/selectionmodels.h"
#include <QMaemo5ListPickSelector>

ValueSelector::ValueSelector(const QString &text, QWidget *parent) :
    QMaemo5ValueButton(text, parent),
    m_model(0),
    m_selector(new QMaemo5ListPickSelector(this))
{
    this->setPickSelector(m_selector);
    this->connect(m_selector, SIGNAL(selected(QString)), this, SLOT(onSelected()));
}

ValueSelector::~ValueSelector() {}

SelectionModel* ValueSelector::model() const {
    return m_model;
}

void ValueSelector::setModel(SelectionModel *model) {
    m_model = model;
    m_selector->setModel(model);
    m_selector->setModelColumn(0);
}

void ValueSelector::setValue(const QVariant &value) {
    if (!m_model) {
        return;
    }

    bool found = false;
    int i = 0;

    while ((!found) && (i < m_model->rowCount())) {
        found = m_model->value(i) == value;

        if (found) {
            m_selector->setCurrentIndex(i);
        }

        i++;
    }

    if (!found) {
        m_selector->setCurrentIndex(0);
    }
}

QVariant ValueSelector::currentValue() {
    return !m_model ? QVariant() : m_model->value(m_selector->currentIndex());
}

void ValueSelector::onSelected() {
    emit valueChanged(this->currentValue());
}
