#ifndef TRANSFERPROPERTIESDIALOG_H
#define TRANSFERPROPERTIESDIALOG_H

#include "../shared/transfer.h"
#include <QDialog>

class QLabel;
class QProgressBar;
class QCheckBox;
class ValueSelector;

class TransferPropertiesDialog : public QDialog
{
    Q_OBJECT

public:
    explicit TransferPropertiesDialog(Transfer *transfer, QWidget *parent = 0);
    ~TransferPropertiesDialog();

private slots:
    void setTransferConnections(const QVariant &value);
    void setTransferCategory(const QVariant &value);
    void setTransferPriority(const QVariant &value);
    void setTransferConvertToAudio(bool convert);
    void onTransferStatusChanged(Transfers::Status status);
    void onTransferDataChanged(int role);

private:
    Transfer *m_transfer;
    QLabel *m_progressLabel;
    QLabel *m_statusLabel;
    QCheckBox *m_convertToAudioCheckBox;
    ValueSelector *m_connectionsSelector;
    ValueSelector *m_categorySelector;
    ValueSelector *m_prioritySelector;
    QProgressBar *m_progressBar;
    QPushButton *m_startButton;
    QPushButton *m_pauseButton;
    QPushButton *m_removeButton;
};

#endif // TRANSFERPROPERTIESDIALOG_H
