#ifndef SETTINGSDIALOG_H
#define SETTINGSDIALOG_H

#include <QDialog>

class QMaemo5ValueButton;
class QCheckBox;
class QModelIndex;

class SettingsDialog : public QDialog
{
    Q_OBJECT

public:
    explicit SettingsDialog(QWidget *parent = 0);
    ~SettingsDialog();

private:
    void loadSettings();

private slots:
    void saveSettings();
    void showFileDialog();
    void showArchivePasswordsDialog();
    void showCategoriesDialog();
    void showServiceAccountsDialog();
    void showDecaptchaAccountsDialog();
    void showPluginSettingsDialog(const QModelIndex &index);
    void showNetworkProxyDialog();

private:
    QMaemo5ValueButton *m_pathSelector;
    QCheckBox *m_statusCheckbox;
    QCheckBox *m_clipboardCheckbox;
    QCheckBox *m_extractArchivesCheckbox;
    QCheckBox *m_archiveSubfoldersCheckbox;
    QCheckBox *m_deleteArchivesCheckbox;
};

#endif // SETTINGSDIALOG_H
