#ifndef RETRIEVEURLSDIALOG_H
#define RETRIEVEURLSDIALOG_H

#include <QDialog>

class QTextEdit;
class QDialogButtonBox;

class RetrieveUrlsDialog : public QDialog
{
    Q_OBJECT

public:
    explicit RetrieveUrlsDialog(QWidget *parent = 0);
    ~RetrieveUrlsDialog();

    QString text() const;

public slots:
    void setText(const QString &text);
    void parseUrlsFromTextFile(const QString &fileName);

private slots:
    void onTextChanged();
    void parseUrls();

private:
    QTextEdit *m_urlsEdit;
    QDialogButtonBox *m_buttonBox;
};

#endif // RETRIEVEURLSDIALOG_H
