#include "pluginsettingsdialog.h"
#include "separatorlabel.h"
#include "pluginsettingsselector.h"
#include "pluginsettingscheckbox.h"
#include "pluginsettingsslider.h"
#include "pluginsettingslineedit.h"
#include "../shared/selectionmodels.h"
#include <QFile>
#include <QHBoxLayout>
#include <QScrollArea>
#include <QDialogButtonBox>
#include <QXmlStreamReader>

PluginSettingsDialog::PluginSettingsDialog(const QString &name, const QString &fileName, QWidget *parent) :
    QDialog(parent)
{
    this->setWindowTitle(name);
    this->setAttribute(Qt::WA_DeleteOnClose, true);
    QHBoxLayout *hbox = new QHBoxLayout(this);
    QDialogButtonBox *buttonBox = new QDialogButtonBox(QDialogButtonBox::Ok, Qt::Vertical, this);
    QScrollArea *scrollArea = new QScrollArea(this);
    QWidget *scrollWidget = new QWidget(scrollArea);
    QVBoxLayout *vbox = new QVBoxLayout(scrollWidget);
    vbox->setContentsMargins(0, 0, 0, 0);
    scrollArea->setHorizontalScrollBarPolicy(Qt::ScrollBarAlwaysOff);
    scrollArea->setWidgetResizable(true);
    scrollArea->setWidget(scrollWidget);

    QFile file(fileName);
    file.open(QIODevice::ReadOnly);
    QXmlStreamReader reader;
    reader.setDevice(&file);
    reader.readNextStartElement();

    while (!reader.atEnd()) {
        if (!reader.attributes().isEmpty()) {
            if (reader.name() == "group") {
                vbox->addWidget(new SeparatorLabel(reader.attributes().value("title").toString(), this));
            }
            else if (reader.name() == "list") {
                PluginSettingsSelector *selector = new PluginSettingsSelector(reader.attributes().value("title").toString(), this);
                selector->setKey(QString("%1/%2").arg(this->windowTitle()).arg(reader.attributes().value("key").toString()));
                selector->setDefaultValue(reader.attributes().value("default").toString());
                reader.readNextStartElement();

                while (reader.name() == "element") {
                    if (!reader.attributes().isEmpty()) {
                        selector->model()->addItem(reader.attributes().value("name").toString(), reader.attributes().value("value").toString());
                    }

                    reader.readNextStartElement();
                }

                selector->load();
                vbox->addWidget(selector);
            }
            else if (reader.name() == "boolean") {
                PluginSettingsCheckbox *checkbox = new PluginSettingsCheckbox(this);
                checkbox->setText(reader.attributes().value("title").toString());
                checkbox->setKey(QString("%1/%2").arg(this->windowTitle()).arg(reader.attributes().value("key").toString()));
                checkbox->setDefaultValue(reader.attributes().value("default").toString());
                checkbox->load();
                vbox->addWidget(checkbox);
            }
            else if (reader.name() == "integer") {
                PluginSettingsSlider *slider = new PluginSettingsSlider(this);
                slider->setKey(QString("%1/%2").arg(this->windowTitle()).arg(reader.attributes().value("key").toString()));
                slider->setDefaultValue(reader.attributes().value("default").toString());
                slider->setMinimum(reader.attributes().value("min").toString().toInt());
                slider->setMaximum(reader.attributes().value("max").toString().toInt());
                slider->setOrientation(Qt::Horizontal);
                slider->load();
                vbox->addWidget(new QLabel(reader.attributes().value("title").toString(), this));
                vbox->addWidget(slider);
            }
            else if (reader.name() == "text") {
                PluginSettingsLineEdit *lineEdit = new PluginSettingsLineEdit(this);
                lineEdit->setKey(QString("%1/%2").arg(this->windowTitle()).arg(reader.attributes().value("key").toString()));
                lineEdit->setDefaultValue(reader.attributes().value("default").toString());
                lineEdit->load();
                vbox->addWidget(new QLabel(reader.attributes().value("title").toString(), this));
                vbox->addWidget(lineEdit);
            }
        }

        reader.readNextStartElement();
    }

    file.close();

    hbox->addWidget(scrollArea, 0, Qt::AlignBottom);
    hbox->addWidget(buttonBox, 0, Qt::AlignBottom);

    this->connect(buttonBox, SIGNAL(accepted()), this, SLOT(accept()));
}

PluginSettingsDialog::~PluginSettingsDialog() {}
