#include "../shared/session.h"
#include "../shared/transfermodel.h"
#include "../shared/pluginmanager.h"
#include "../shared/settings.h"
#include "../shared/urlchecker.h"
#include "../shared/database.h"
#include "../shared/selectionmodels.h"
#include "../shared/categoriesmodel.h"
#include "../shared/serviceaccountsmodel.h"
#include "../shared/decaptchaaccountsmodel.h"
#include "../shared/pluginsettingsmodel.h"
#include "../shared/definitions.h"
#include "folderlistmodel.h"
#include "qmlutils.h"
#include "maskeditem.h"
#include <QApplication>
#include <MDeclarativeCache>
#include <QtDeclarative>
#include <QGLWidget>

Q_DECL_EXPORT int main(int argc, char *argv[])
{
    QScopedPointer<QApplication> app(MDeclarativeCache::qApplication(argc, argv));
    QScopedPointer<QDeclarativeView> view(MDeclarativeCache::qDeclarativeView());
    Session session;
    QmlUtils utils;

    qRegisterMetaType<ScreenOrientation::Orientation>("ScreenOrientation::Orientation");
    qRegisterMetaType<Transfers::Status>("Transfers::Status");
    qRegisterMetaType<Transfers::Priority>("Transfers::Priority");

    qmlRegisterType<QDeclarativeFolderListModel>("com.marxian.models",1,0,"FolderListModel");
    qmlRegisterType<ScreenOrientationModel>("com.marxian.models",1,0,"ScreenOrientationModel");
    qmlRegisterType<QMLSettingsModel>("com.marxian.models",1,0,"SettingsModel");
    qmlRegisterType<QMLAccountsModel>("com.marxian.models",1,0,"AccountsModel");
    qmlRegisterType<ConcurrentTransfersModel>("com.marxian.models",1,0,"ConcurrentTransfersModel");
    qmlRegisterType<TransferPriorityModel>("com.marxian.models",1,0,"TransferPriorityModel");
    qmlRegisterType<CategoriesModel>("com.marxian.models",1,0,"CategoriesModel");
    qmlRegisterType<ServiceAccountsModel>("com.marxian.models",1,0,"ServiceAccountsModel");
    qmlRegisterType<DecaptchaAccountsModel>("com.marxian.models",1,0,"DecaptchaAccountsModel");
    qmlRegisterType<PluginSettingsModel>("com.marxian.models",1,0,"PluginSettingsModel");
    qmlRegisterType<NetworkProxyTypeModel>("com.marxian.models",1,0,"NetworkProxyTypeModel");
    qmlRegisterType<SelectionModel>("com.marxian.models",1,0,"SelectionModel");
    qmlRegisterType<MaskedItem>("com.marxian.items",1,0,"MaskedItem");
    qmlRegisterType<Transfer>("com.marxian.items",1,0,"Transfer");
    qmlRegisterUncreatableType<UrlChecker>("do_not_import_this_module",1,0,"UrlChecker","Cannot create this item in QML");
    qmlRegisterUncreatableType<TransferModel>("do_not_import_this_module",1,0,"TransferModel","Cannot create this item in QML");
    qmlRegisterUncreatableType<PluginManager>("do_not_import_this_module",1,0,"PluginManager","Cannot create this item in QML");
    qmlRegisterUncreatableType<Database>("do_not_import_this_module",1,0,"Database","Cannot create this item in QML");
    qmlRegisterUncreatableType<Settings>("do_not_import_this_module",1,0,"Settings","Cannot create this item in QML");
    qmlRegisterUncreatableType<Transfers>("com.marxian.enums",1,0,"Transfers","Cannot create this item in QML");
    qmlRegisterUncreatableType<ScreenOrientation>("com.marxian.enums",1,0,"ScreenOrientation","Cannot create this item in QML");
    qmlRegisterUncreatableType<NetworkProxyType>("com.marxian.enums",1,0,"NetworkProxyType","Cannot create this item in QML");

    QDeclarativeContext *context = view->rootContext();
    context->setContextProperty("Session", &session);
    context->setContextProperty("TransferModel", TransferModel::instance());
    context->setContextProperty("UrlChecker", UrlChecker::instance());
    context->setContextProperty("PluginManager", PluginManager::instance());
    context->setContextProperty("Database", Database::instance());
    context->setContextProperty("Settings", Settings::instance());
    context->setContextProperty("Utils", &utils);
    context->setContextProperty("iconPath", ICON_PATH);

    view->setViewport(new QGLWidget());
    view->setSource(QUrl("qrc:/main.qml"));
    view->showFullScreen();

    return app->exec();
}
