#ifndef TRANSFERPROPERTIESDIALOG_H
#define TRANSFERPROPERTIESDIALOG_H

#include "../shared/transfer.h"
#include <QDialog>

class QLabel;
class QComboBox;
class QProgressBar;
class QCheckBox;

class TransferPropertiesDialog : public QDialog
{
    Q_OBJECT

public:
    explicit TransferPropertiesDialog(Transfer *transfer, QWidget *parent = 0);
    ~TransferPropertiesDialog();
    
private slots:
    void onTransferStatusChanged(Transfers::Status status);
    void onTransferDataChanged(int role);
    void setTransferConnections(int index);
    void setTransferCategory(const QString &text);
    void setTransferPriority(int index);
    void setTransferConvertToAudio(bool convert);

private:
    Transfer *m_transfer;
    QCheckBox *m_convertToAudioCheckBox;
    QComboBox *m_connectionsSelector;
    QComboBox *m_categorySelector;
    QComboBox *m_prioritySelector;
    QLabel *m_progressLabel;
    QLabel *m_statusLabel;
    QProgressBar *m_progressBar;
    QPushButton *m_startButton;
    QPushButton *m_pauseButton;
    QPushButton *m_removeButton;
};

#endif // TRANSFERPROPERTIESDIALOG_H
