#include "separatorlabel.h"
#include <QHBoxLayout>
#include <QLabel>
#include <QApplication>

SeparatorLabel::SeparatorLabel(const QString &text, QWidget *parent) :
    QWidget(parent),
    m_label(new QLabel(text, this))
{
    this->setStyleSheet(QString("color: %1").arg(QApplication::palette().color(QPalette::Mid).name()));

    QHBoxLayout *hbox = new QHBoxLayout(this);
    QFrame *line = new QFrame(this);

    line->setFrameShape(QFrame::HLine);
    line->setLineWidth(1);

    hbox->addWidget(line, 1);
    hbox->addWidget(m_label, 0, Qt::AlignVCenter);
}

SeparatorLabel::~SeparatorLabel() {}
