import QtQuick 1.1
import com.nokia.symbian 1.1

Item {
    id: root

    width: !parent ? implicitWidth : parent.width
    height: 48

    Label {
        id: urlLabel

        anchors {
            left: parent.left
            leftMargin: 5
            right: icon.left
            rightMargin: 5
            verticalCenter: parent.verticalCenter
        }

        elide: Text.ElideRight
        text: url
    }

    Image {
        id: icon

        anchors {
            right: parent.right
            rightMargin: 5
            verticalCenter: parent.verticalCenter
        }

        source: !checked ? "" : ok ? "qrc:/done.png" : "qrc:/close.png"
    }
}
