import QtQuick 1.1
import com.nokia.symbian 1.1
import com.marxian.models 1.0

Page {
    id: root

    orientationLock: Settings.screenOrientation
    tools: ToolBarLayout {

        ToolButton {
            iconSource: "toolbar-back"
            onClicked: pageStack.pop()
        }
    }

    ListView {
        id: view

        anchors.fill: parent
        model: SettingsModel {}
        header: TitleHeader {
            title: qsTr("Settings")
        }
        delegate: SettingsDelegate {
            onClicked: pageStack.push(Qt.resolvedUrl(value))
        }
    }

    ScrollDecorator {
        flickableItem: view
    }
}
