import QtQuick 1.1
import com.nokia.symbian 1.1

Item {
    id: root

    property string __key
    property alias title: titleLabel.text
    property alias minimumValue: slider.minimumValue
    property alias maximumValue: slider.maximumValue
    property alias stepSize: slider.stepSize

    function setKey(key, defaultValue) {
        root.__key = key;
        var value = Settings.setting(key);

        if (value === undefined) {
            slider.value = parseFloat(defaultValue);
        }
        else {
            slider.value = parseFloat(value);
        }
    }

    height: 80
    width: !parent ? implicitWidth : parent.width

    Label {
        id: titleLabel

        anchors {
            left: parent.left
            leftMargin: 10
            right: parent.right
            rightMargin: 10
            top: parent.top
        }

        elide: Text.ElideRight
    }

    Slider {
        id: slider

        anchors {
            left: parent.left
            leftMargin: 30
            right: parent.right
            rightMargin: 30
            top: titleLabel.bottom
        }

        orientation: Qt.Horizontal
        valueIndicatorVisible: true
        onValueChanged: Settings.setSetting(root.__key, slider.value)
    }
}
