import QtQuick 1.1
import com.marxian.models 1.0

MySelectionDialog {
    id: root

    signal valueChosen(string name, variant value)

    function setValue(value) {
        var i = 0;
        var found = false;

        while ((!found) && (i < selectionModel.count)) {
            found = (selectionModel.value(i) === value);

            if (found) {
                root.selectedIndex = i;
            }

            i++;
        }
    }

    model: SelectionModel {
        id: selectionModel
    }

    onAccepted: root.valueChosen(selectionModel.name(root.selectedIndex), selectionModel.value(root.selectedIndex))
}
