import QtQuick 1.1
import com.nokia.symbian 1.1

ListItem {
    id: root

    width: !parent ? implicitWidth : parent.width
    height: 80
    subItemIndicator: true

    ServiceIcon {
        id: icon

        width: 64
        height: 64
        smooth: true
        anchors {
            left: parent.left
            leftMargin: 10
            verticalCenter: parent.verticalCenter
        }

        iconSource: iconPath + pluginIcon
    }

    Label {
        anchors {
            left: icon.right
            leftMargin: 10
            right: parent.right
            rightMargin: 10
            verticalCenter: parent.verticalCenter
        }

        wrapMode: Text.NoWrap
        elide: Text.ElideRight
        text: pluginName
    }
}
