import QtQuick 1.1
import com.nokia.symbian 1.1
import "scripts/createobject.js" as ObjectCreator

MySheet {
    id: root

    property alias name: nameField.text
    property string path

    signal categorySet(string name, string path)

    function showFileBrowserDialog() {
        var dialog = ObjectCreator.createObject(Qt.resolvedUrl("FileBrowserDialog.qml"), pageStack);
        dialog.startFolder = (root.path == "" ? "/home/user/MyDocs/" : root.path);
        dialog.open();
        dialog.fileChosen.connect(root.setPath);
    }

    function setPath(p) {
        root.path = p;
    }

    rejectButtonText: qsTr("Cancel")
    acceptButtonText: (nameField.text == "") || (root.path == "") ? "" : qsTr("Done")
    content: Item {
        id: contentItem

        anchors.fill: parent
        clip: true

        Flickable {
            id: flicker

            anchors {
                fill: parent
                topMargin: 10
                leftMargin: 10
                rightMargin: 10
            }

            contentHeight: column.height

            Column {
                id: column

                anchors {
                    top: parent.top
                    left: parent.left
                    right: parent.right
                }

                spacing: 10

                Label {
                    text: qsTr("Name")
                }

                TextField {
                    id: nameField

                    width: parent.width
                    Keys.onEnterPressed: nameField.closeSoftwareInputPanel()
                    Keys.onReturnPressed: nameField.closeSoftwareInputPanel()
                }

                SelectionListItem {
                    id: pathSelector

                    x: -10
                    width: parent.width + 20
                    title: qsTr("Download path")
                    subTitle: root.path == "" ? qsTr("None chosen") : root.path
                    onClicked: root.showFileBrowserDialog()
                }
            }
        }

        ScrollDecorator {
            flickableItem: flicker
        }
    }

    onAccepted: root.categorySet(nameField.text, pathField.text)
}
