import QtQuick 1.1
import com.nokia.symbian 1.1

ListItem {
    id: root

    width: !parent ? implicitWidth : parent.width
    height: 80

    ServiceIcon {
        id: icon

        width: 64
        height: 64
        smooth: true
        anchors {
            left: parent.left
            leftMargin: 10
            verticalCenter: parent.verticalCenter
        }

        iconSource: iconPath + serviceIcon
    }

    Label {
        anchors {
            top: icon.top
            left: icon.right
            leftMargin: 10
            right: parent.right
            rightMargin: 10
        }

        wrapMode: Text.NoWrap
        elide: Text.ElideRight
        text: serviceName
    }

    Label {
        anchors {
            bottom: parent.bottom
            left: icon.right
            leftMargin: 10
            right: parent.right
            rightMargin: 10
        }

        color: "#4d4d4d"
        wrapMode: Text.NoWrap
        elide: Text.ElideRight
        text: username === "" ? qsTr("No account") : username
    }
}
