import QtQuick 1.1
import com.nokia.meego 1.0

Item {
    id: root

    width: parent.width
    height: 48

    Label {
        id: urlLabel

        anchors {
            left: parent.left
            leftMargin: 5
            right: icon.left
            rightMargin: 5
            verticalCenter: parent.verticalCenter
        }

        font.pixelSize: 20
        elide: Text.ElideRight
        text: url
    }

    Image {
        id: icon

        anchors {
            right: parent.right
            rightMargin: 5
            verticalCenter: parent.verticalCenter
        }

        source: !checked ? "" : ok ? "image://theme/icon-m-toolbar-done-white" : "image://theme/icon-m-toolbar-cancle-white"
    }
}
