import QtQuick 1.1
import com.nokia.meego 1.0

Item {
    id: root

    height: 72

    property alias text: textField.text
    property alias placeholderText: textField.placeholderText
    property string __screenOrientation: appWindow.inPortrait ? "portrait" : "landscape"

    signal accepted(string text)

    Image {
        anchors.fill: parent
        source: "image://theme/meegotouch-tab-" + __screenOrientation + "-bottom-inverted-background"
        fillMode: Image.Stretch
    }

    TextField {
        id: textField

        anchors {
            left: parent.left
            leftMargin: 10
            right: parent.right
            rightMargin: 10
            verticalCenter: parent.verticalCenter
        }

        platformStyle: TextFieldStyle {
            paddingRight: 55
        }

        Keys.onEnterPressed: {
            textField.platformCloseSoftwareInputPanel();
            root.accepted(textField.text);
        }

        Keys.onReturnPressed: {
            textField.platformCloseSoftwareInputPanel();
            root.accepted(textField.text);
        }

        inputMethodHints: Qt.ImhNoPredictiveText | Qt.ImhNoAutoUppercase
        platformSipAttributes: SipAttributes {
            actionKeyEnabled: textField.text != ""
            actionKeyHighlighted: true
            actionKeyLabel: qsTr("Add")
            actionKeyIcon: ""
        }
    }

    Image {
        id: icon

        z: 1000
        anchors {
            right: textField.right
            rightMargin: 10
            verticalCenter: textField.verticalCenter
        }

        source: "image://theme/icon-m-input-clear"
        opacity: mouseArea.pressed ? 0.5 : 1
        visible: textField.text != ""

        MouseArea {
            id: mouseArea

            width: 60
            height: 60
            anchors.centerIn: parent
            onClicked: {
                textField.text = "";
                textField.platformCloseSoftwareInputPanel();
            }
        }
    }
}
