import QtQuick 1.1
import com.nokia.meego 1.0

Item {
    id: root

    signal clicked

    width: parent.width
    height: 80

    Rectangle {
        anchors.fill: parent
        color: "#4d4d4d"
        opacity: 0.5
        visible: mouseArea.pressed
    }

    Label {
        id: title

        anchors {
            left: parent.left
            leftMargin: 10
            right: icon.left
            rightMargin: 10
            verticalCenter: parent.verticalCenter
        }

        font.bold: true
        verticalAlignment: Text.AlignVCenter
        elide: Text.ElideRight
        text: name
    }

    Image {
        id: icon

        anchors {
            right: parent.right
            rightMargin: 10
            verticalCenter: parent.verticalCenter
        }

        source: "image://theme/icon-m-common-drilldown-arrow-inverse"
    }

    MouseArea {
        id: mouseArea

        anchors.fill: parent
        onClicked: parent.clicked()
    }
}
