import QtQuick 1.1
import com.nokia.meego 1.0
import "scripts/createobject.js" as ObjectCreator

SelectionItem {
    id: root

    function setList(key, defaultValue, list) {
        internal.key = key;
        internal.list = list;
        var value = Settings.setting(key);

        if (value === undefined) {
            value = defaultValue;
            Settings.setSetting(key, value);
        }

        var i = 0;

        while ((!root.subTitle) && (i < list.length)) {
            if (list[i].value === value) {
                root.subTitle = list[i].name;
            }

            i++;
        }
    }

    function showSelectionDialog() {
        var dialog = ObjectCreator.createObject(Qt.resolvedUrl("PluginSettingsSelectionDialog.qml"), pageStack);
        dialog.titleText = root.title;

        for (var i = 0; i < internal.list.length; i++) {
            dialog.model.addItem(internal.list[i].name, internal.list[i].value);
        }

        dialog.setValue(Settings.setting(internal.key));
        dialog.valueChosen.connect(root.onValueChosen);
        dialog.open();
    }

    function onValueChosen(name, value) {
        root.subTitle = name;
        Settings.setSetting(internal.key, value);
    }

    width: !parent ? implicitWidth : parent.width
    height: 80
    onClicked: root.showSelectionDialog()

    QtObject {
        id: internal

        property string key
        property variant list
    }
}
