import QtQuick 1.1
import com.nokia.meego 1.0

Item {
    id: root

    property alias text: label.text

    height: 80
    width: !parent ? implicitWidth : parent.width

    Label {
        id: label

        anchors {
            right: parent.right
            rightMargin: 10
            verticalCenter: parent.verticalCenter
        }

        font.pixelSize: 18
        font.bold: true
        color: "#4d4d4d"
        horizontalAlignment: Text.AlignRight
        verticalAlignment: Text.AlignVCenter
    }

    Rectangle {
        height: 1
        anchors {
            left: parent.left
            leftMargin: 10
            right: label.left
            rightMargin: 10
            verticalCenter: label.verticalCenter
        }

        color: "#4d4d4d"
    }
}
