import QtQuick 1.1
import com.nokia.meego 1.0
import "scripts/createobject.js" as ObjectCreator

Page {
    id: root

    orientationLock: Settings.screenOrientation
    tools: ToolBarLayout {

        ToolIcon {
            platformIconId: "toolbar-back"
            onClicked: appWindow.pageStack.pop()
        }
    }

    Flickable {
        id: flicker

        anchors.fill: parent
        contentHeight: column.height

        Column {
            id: column

            anchors {
                top: parent.top
                left: parent.left
                right: parent.right
            }

            TitleHeader {
                title: qsTr("Downloads")
            }

            SelectionItem {
                id: folderSelector

                title: qsTr("Default download path")
                subTitle: Settings.downloadPath
                enabled: TransferModel.count == 0
                onClicked: {
                    var dialog = ObjectCreator.createObject(Qt.resolvedUrl("FileBrowserDialog.qml"), appWindow.pageStack);
                    dialog.open();
                    dialog.fileChosen.connect(Settings.setDownloadPath)
                }
            }

            SelectionItem {
                id: concurrentSelector

                title: qsTr("Concurrent downloads")
                subTitle: Settings.maximumConcurrent
                onClicked: {
                    var dialog = ObjectCreator.createObject(Qt.resolvedUrl("ConcurrentTransfersSelectionDialog.qml"), appWindow.pageStack);
                    dialog.open();
                }
            }

            SwitchItem {
                id: autoSwitch

                title: qsTr("Start downloads automatically")
                checked: Settings.startTransfersAutomatically
                onCheckedChanged: Settings.startTransfersAutomatically = checked
            }
        }
    }
}
