import QtQuick 1.1
import com.nokia.meego 1.0
import com.marxian.models 1.0

MySelectionDialog {
    id: root

    function setValue(value) {
        var i = 0;
        var found = false;

        while ((!found) && (i < transfersModel.count)) {
            found = (transfersModel.value(i) === value);

            if (found) {
                root.selectedIndex = i;
            }

            i++;
        }
    }

    titleText: qsTr("Concurrent downloads")
    model: ConcurrentTransfersModel {
        id: transfersModel
    }

    onAccepted: Settings.maximumConcurrent = transfersModel.value(root.selectedIndex)

    Component.onCompleted: root.setValue(Settings.maximumConcurrent)
}
