import QtQuick 1.1
import com.marxian.models 1.0

MySelectionDialog {
    id: root

    signal valueChosen(string value)

    function setValue(value) {
        var i = 0;
        var found = false;

        while ((!found) && (i < categoriesModel.count)) {
            found = (categoriesModel.name(i) === value);

            if (found) {
                root.selectedIndex = i;
            }

            i++;
        }
    }

    titleText: qsTr("Category")
    model: CategoriesModel {
        id: categoriesModel

        session: Session
    }

    onAccepted: root.valueChosen(categoriesModel.name(root.selectedIndex))
}
