#ifndef URLCHECKER_H
#define URLCHECKER_H

#include <QObject>
#include <QUrl>
#include <QQueue>
#include <QStringList>
#include "pluginmanager.h"

class QNetworkAccessManager;

class UrlChecker : public QObject
{
    Q_OBJECT

    Q_PROPERTY(bool urlChecksCancelled
               READ urlChecksCancelled
               WRITE cancelUrlChecks
               NOTIFY urlChecksCancelledChanged)

public:
    explicit UrlChecker(QObject *parent = 0);
    inline QNetworkAccessManager *networkAccessManager() const { return m_nam; }
    void setNetworkAccessManager(QNetworkAccessManager *manager);
    inline PluginManager *pluginManager() const { return m_manager; }
    void setPluginManager(PluginManager *manager);
    inline bool urlChecksCancelled() const { return m_cancelled; }

public slots:
    void addUrlToQueue(const QUrl &url);
    void addUrlToQueue(const QString &url);
    void addUrlsToQueue(QList<QUrl> urls);
    void addUrlsToQueue(QStringList urls);
    void parseUrlsFromText(const QString &text);
    void importUrlsFromTextFile(const QString &filePath);
    inline void cancelUrlChecks(bool cancel = true) { m_cancelled = cancel; emit urlChecksCancelledChanged(cancel); }

private:
    void testFileDownload(const QUrl &url);

private slots:
    void connectToPluginSignals();
    void checkUrl(const QUrl &url);
    void checkFileDownload();
    void onUrlChecked(bool ok, const QUrl &url, const QString &service, const QString &fileName, bool done);

signals:
    void urlChecked(bool ok, const QUrl &url, const QString &service, const QString &fileName, bool done);
    void urlsQueued(const QList<QUrl> &urls);
    void urlsQueued(const QStringList &urls);
    void urlChecksCancelledChanged(bool cancelled);
    
private:
    QNetworkAccessManager *m_nam;
    PluginManager *m_manager;
    QQueue<QUrl> m_urlQueue;
    bool m_cancelled;
};

#endif // URLCHECKER_H
