#include "serviceaccountsmodel.h"

ServiceAccountsModel::ServiceAccountsModel(Session *session, QObject *parent) :
    QAbstractTableModel(parent),
    m_session(session)
{
    QHash<int, QByteArray> roles;
    roles[ServiceNameRole] = "serviceName";
    roles[ServiceIconRole] = "serviceIcon";
    roles[UsernameRole] = "username";
    roles[PasswordRole] = "password";

    this->setRoleNames(roles);

    if (this->session()) {
        this->loadAccounts();
    }
}

void ServiceAccountsModel::setSession(Session *session) {
    m_session = session;

    if (this->session()) {
        this->loadAccounts();
    }
}

int ServiceAccountsModel::rowCount(const QModelIndex &parent) const {
    Q_UNUSED(parent)

    return m_list.size();
}

int ServiceAccountsModel::columnCount(const QModelIndex &parent) const {
    Q_UNUSED(parent)

    return 3;
}

QVariant ServiceAccountsModel::headerData(int section, Qt::Orientation orientation, int role) const {
    if ((role != Qt::DisplayRole) || (orientation != Qt::Horizontal)) {
        return QVariant();
    }

    switch (section) {
    case 0:
        return tr("Service");
    case 1:
        return QString("%1/%2").arg(tr("Username")).arg(tr("email"));
    case 2:
        return tr("Password");
    default:
        return QVariant();
    }
}

QVariant ServiceAccountsModel::data(const QModelIndex &index, int role) const {
    switch (role) {
    case ServiceNameRole:
        return m_list.at(index.row()).serviceName;
    case ServiceIconRole:
        return m_list.at(index.row()).serviceIcon;
    case UsernameRole:
        return m_list.at(index.row()).username;
    case PasswordRole:
        return m_list.at(index.row()).password;
    default:
        return QVariant();
    }
}

QVariant ServiceAccountsModel::data(int row, int role) const {
    return this->data(this->index(row, 0), role);
}

QString ServiceAccountsModel::serviceName(int row) const {
    return this->data(row, ServiceNameRole).toString();
}

QString ServiceAccountsModel::serviceIcon(int row) const {
    return this->data(row, ServiceIconRole).toString();
}

QString ServiceAccountsModel::username(int row) const {
    return this->data(row, UsernameRole).toString();
}

QString ServiceAccountsModel::password(int row) const {
    return this->data(row, PasswordRole).toString();
}

void ServiceAccountsModel::loadAccounts() {
    this->beginResetModel();
    m_list.clear();

    for (int i = 0; i < this->session()->pluginManager()->servicePlugins().size(); i++) {
        ServicePlugin *plugin = this->session()->pluginManager()->servicePlugins().at(i);

        if (plugin->loginSupported()) {
            QPair<QString, QString> account = this->session()->database()->getAccount(plugin->serviceName());
            ServiceAccount serviceAccount;
            serviceAccount.serviceName = plugin->serviceName();
            serviceAccount.serviceIcon = plugin->iconName();
            serviceAccount.username = account.first;
            serviceAccount.password = account.second;
            m_list.append(serviceAccount);
        }
    }

    this->endResetModel();

    emit countChanged(this->rowCount());
}

void ServiceAccountsModel::addAccount(const QString &serviceName, const QString &username, const QString &password) {
    if (this->session()->database()->addAccount(serviceName, username, password)) {
        this->loadAccounts();
    }
}

void ServiceAccountsModel::removeAccount(const QString &serviceName) {
    if (this->session()->database()->removeAccount(serviceName)) {
        this->loadAccounts();
    }
}
