#include "pluginsettingsmodel.h"
#include <QDomDocument>
#include <QDomElement>
#include <QDir>
#include <QFile>
#include <QCoreApplication>

PluginSettingsModel::PluginSettingsModel(QObject *parent) :
    QAbstractListModel(parent)
{
    QHash<int, QByteArray> roles;
    roles[PluginNameRole] = "pluginName";
    roles[PluginIconRole] = "pluginIcon";
    roles[FileNameRole] = "fileName";
    this->setRoleNames(roles);
    this->loadSettingsFiles();
}

int PluginSettingsModel::rowCount(const QModelIndex &parent) const {
    Q_UNUSED(parent)

    return m_list.size();
}

QVariant PluginSettingsModel::data(const QModelIndex &index, int role) const {
    if (!index.isValid()) {
        return QVariant();
    }

    switch (role) {
    case PluginNameRole:
        return m_list.at(index.row()).name;
    case PluginIconRole:
        return m_list.at(index.row()).icon;
    case FileNameRole:
        return m_list.at(index.row()).fileName;
    default:
        return QVariant();
    }
}

void PluginSettingsModel::loadSettingsFiles() {
    if (this->rowCount() > 0) {
        this->beginRemoveRows(QModelIndex(), 0, this->rowCount() - 1);
        m_list.clear();
        this->endRemoveRows();
    }

    QDir dir(QCoreApplication::applicationDirPath());
    dir.cdUp();
    dir.cd("settings");

    foreach (QString fileName, dir.entryList(QStringList() << "*.xml", QDir::Files)) {
        QFile file(dir.absoluteFilePath(fileName));

        if (file.open(QIODevice::ReadOnly)) {
            QString xml(file.readAll());
            QDomDocument doc;
            doc.setContent(xml);
            QDomElement root = doc.documentElement();
            Setting setting;
            setting.name = root.attribute("title");
            setting.icon = root.attribute("icon");
            setting.fileName = file.fileName();

            this->beginInsertRows(QModelIndex(), this->rowCount(), this->rowCount());
            m_list.append(setting);
            this->endInsertRows();
        }
    }

    emit countChanged(this->rowCount());
}
