#ifndef DATABASE_H
#define DATABASE_H

#include "transferitem.h"
#include <QObject>
#include <QSqlDatabase>
#include <QSharedPointer>
#include <QPair>

class Database : public QObject
{
    Q_OBJECT

public:
    explicit Database(QObject *parent = 0);
    ~Database() {}

public slots:
    void initialize();
    bool addCategory(const QString &name, const QString &path);
    bool removeCategory(const QString &name);
    QString getCategoryPath(const QString &name);
    QList< QPair<QString, QString> > getCategories();
    bool addAccount(const QString &serviceName, const QString &username, const QString &password);
    bool removeAccount(const QString &serviceName);
    QPair<QString, QString> getAccount(const QString &serviceName);
    QList< QSharedPointer<TransferItem> > getStoredDownloads();
    bool storeDownload(QSharedPointer<TransferItem> transfer);
    bool removeStoredDownload(const QString &id);
    bool updateStoredDownload(const QString &id, const QString &key, const QVariant &value);

signals:
    void error(const QString &message);
    void categoriesChanged();

private:
    QSqlDatabase m_database;
};

#endif // DATABASE_H
