#include "transferprioritydialog.h"
#include "textlistdelegate.h"
#include "../shared/selectionmodels.h"
#include <QListView>
#include <QGridLayout>

TransferPriorityDialog::TransferPriorityDialog(QWidget *parent) :
    QDialog(parent),
    m_model(new TransferPriorityModel(this)),
    m_listView(new QListView(this))
{
    this->setWindowTitle(tr("Priority"));
    this->setAttribute(Qt::WA_DeleteOnClose, true);
    this->setFixedHeight(340);

    QGridLayout *grid = new QGridLayout(this);
    grid->addWidget(m_listView, 0, 0);

    m_listView->setModel(m_model);
    m_listView->setItemDelegate(new TextListDelegate(Qt::DisplayRole, Qt::AlignCenter, m_listView));

    this->connect(m_listView, SIGNAL(clicked(QModelIndex)), this, SLOT(onItemClicked(QModelIndex)));
}

void TransferPriorityDialog::setValue(Transfers::Priority priority) {
    bool found = false;
    int i = 0;

    while ((!found) && (i < m_model->rowCount())) {
        found = static_cast<Transfers::Priority>(m_model->value(i).toInt()) == priority;

        if (found) {
            m_listView->setCurrentIndex(m_model->index(i, 0));
        }

        i++;
    }

    if (!found) {
        m_listView->setCurrentIndex(m_model->index(0, 0));
    }
}

Transfers::Priority TransferPriorityDialog::currentValue() const {
    return static_cast<Transfers::Priority>(m_model->value(m_listView->currentIndex().row()).toInt());
}

void TransferPriorityDialog::onItemClicked(const QModelIndex &index) {
    emit valueChanged(static_cast<Transfers::Priority>(m_model->value(index.row()).toInt()));
    this->accept();
}
