#ifndef STRINGSELECTOR_H
#define STRINGSELECTOR_H

#include <QMaemo5ValueButton>

class SelectionModel;
class QMaemo5ListPickSelector;

class StringSelector : public QMaemo5ValueButton
{
    Q_OBJECT

public:
    explicit StringSelector(SelectionModel *model, const QString &text, QWidget *parent = 0);
    void setValue(const QString &value);
    QString currentValue() const;
    
private slots:
    void onSelected();

signals:
    void valueChanged(const QString &value);

private:
    SelectionModel *m_model;
    QMaemo5ListPickSelector *m_selector;
};

#endif // STRINGSELECTOR_H
