#ifndef SETTINGSDIALOG_H
#define SETTINGSDIALOG_H

#include <QDialog>

class Session;
class ConcurrentTransfersSelector;
class QMaemo5ValueButton;
class QCheckBox;
class QModelIndex;

class SettingsDialog : public QDialog
{
    Q_OBJECT

public:
    explicit SettingsDialog(Session *session, QWidget *parent = 0);

private:
    void loadSettings();

private slots:
    void saveSettings();
    void showFileDialog();
    void showCategoriesDialog();
    void showServiceAccountsDialog();
    void showDecaptchaAccountsDialog();
    void showPluginSettingsDialog(const QModelIndex &index);
    void showNetworkProxyDialog();

private:
    Session *m_session;
    QMaemo5ValueButton *m_pathSelector;
    QCheckBox *m_statusCheckbox;
    ConcurrentTransfersSelector *m_concurrentSelector;
    QCheckBox *m_clipboardCheckbox;
};

#endif // SETTINGSDIALOG_H
