#ifndef NEWCATEGORYDIALOG_H
#define NEWCATEGORYDIALOG_H

#include <QDialog>

class Session;
class QLineEdit;
class QMaemo5ValueButton;

class NewCategoryDialog : public QDialog
{
    Q_OBJECT

public:
    explicit NewCategoryDialog(Session *session, QWidget *parent = 0);

public slots:
    void setName(const QString &name);
    void setPath(const QString &path);

private slots:
    void onNameTextChanged(const QString &text);
    void showFileDialog();
    void addCategory();

signals:
    void addCategory(const QString &name, const QString &path);
    
private:
    Session *m_session;
    QLineEdit *m_nameEdit;
    QMaemo5ValueButton *m_pathSelector;
    QPushButton *m_doneButton;
    QString m_path;
};

#endif // NEWCATEGORYDIALOG_H
