#include "decaptchapassworddelegate.h"
#include "../shared/decaptchaaccountsmodel.h"
#include <QPainter>

DecaptchaPasswordDelegate::DecaptchaPasswordDelegate(QObject *parent) :
    QStyledItemDelegate(parent)
{
}

void DecaptchaPasswordDelegate::paint(QPainter *painter, const QStyleOptionViewItem &option, const QModelIndex &index) const {
    if ((option.state) & (QStyle::State_Selected)) {
        painter->drawImage(option.rect, QImage("/etc/hildon/theme/images/TouchListBackgroundPressed.png"));
    }

    QRect textRect = option.rect;
    textRect.setLeft(textRect.left() + 5);

    QString password = index.data(DecaptchaAccountsModel::PasswordRole).toString();

    if (!password.isEmpty()) {
        painter->drawText(textRect, Qt::AlignVCenter, QString("********"));
    }
}

QSize DecaptchaPasswordDelegate::sizeHint(const QStyleOptionViewItem &option, const QModelIndex &index) const {
    Q_UNUSED(index)

    return QSize(option.rect.width(), 60);
}
