#include "categorynamedelegate.h"
#include "../shared/categoriesmodel.h"
#include <QPainter>

CategoryNameDelegate::CategoryNameDelegate(QObject *parent) :
    QStyledItemDelegate(parent)
{
}

void CategoryNameDelegate::paint(QPainter *painter, const QStyleOptionViewItem &option, const QModelIndex &index) const {
    if ((option.state) & (QStyle::State_Selected)) {
        painter->drawImage(option.rect, QImage("/etc/hildon/theme/images/TouchListBackgroundPressed.png"));
    }

    QRect textRect = option.rect;
    textRect.setLeft(textRect.left() + 5);

    painter->drawText(textRect, Qt::AlignVCenter, index.data(CategoriesModel::NameRole).toString());
}

QSize CategoryNameDelegate::sizeHint(const QStyleOptionViewItem &option, const QModelIndex &index) const {
    Q_UNUSED(index)

    return QSize(option.rect.width(), 60);
}
