#include "transferprogressdelegate.h"
#include "../shared/transfermodel.h"
#include <QApplication>
#include <QStyleOptionProgressBar>
#include <QPainter>

TransferProgressDelegate::TransferProgressDelegate(QObject *parent) :
    QStyledItemDelegate(parent)
{
}

void TransferProgressDelegate::paint(QPainter *painter, const QStyleOptionViewItem &option, const QModelIndex &index) const {
    if (index.data(TransferModel::SelectedRole).toBool()) {
        painter->fillRect(option.rect, Qt::cyan);
    }
    else if (index.data(TransferModel::EnteredRole).toBool()) {
        painter->fillRect(option.rect, Qt::lightGray);
    }

    int progress = index.data(TransferModel::ProgressRole).toInt();

    QRect progressRect = option.rect;
    progressRect.setTop(progressRect.top() + 2);
    progressRect.setBottom(progressRect.bottom() - 2);

    QStyleOptionProgressBar progressBar;
    progressBar.rect = progressRect;
    progressBar.minimum = 0;
    progressBar.maximum = 100;
    progressBar.progress = progress;
    progressBar.text = QString::number(progress) + "%";
    progressBar.textVisible = true;

    QApplication::style()->drawControl(QStyle::CE_ProgressBar, &progressBar, painter);
}

QSize TransferProgressDelegate::sizeHint(const QStyleOptionViewItem &option, const QModelIndex &index) const {
    Q_UNUSED(index);

    return QSize(option.rect.width(), 25);
}
