#include "settingsdialog.h"
#include "downloadsettingstab.h"
#include "categorysettingstab.h"
#include "accountsettingstab.h"
#include "captchasettingstab.h"
#include "pluginsettingstab.h"
#include "../shared/pluginsettingsmodel.h"
#include <QListWidgetItem>
#include <QGridLayout>
#include <QDialogButtonBox>
#include <QListWidget>
#include <QStackedWidget>

SettingsDialog::SettingsDialog(Session *session, QWidget *parent) :
    QDialog(parent),
    m_session(session)
{
    this->setWindowTitle(tr("Preferences"));
    this->setAttribute(Qt::WA_DeleteOnClose, true);
    this->setMinimumSize(600, 300);

    QListWidget *listWidget = new QListWidget(this);
    listWidget->setFixedWidth(120);
    listWidget->addItems(QStringList() << tr("General") << tr("Categories") << tr("Accounts") << tr("Decaptcha"));
    listWidget->item(0)->setIcon(QIcon::fromTheme("preferences-system"));
    listWidget->item(1)->setIcon(QIcon::fromTheme("view-list-details"));
    listWidget->item(2)->setIcon(QIcon::fromTheme("user-properties"));
    listWidget->item(3)->setIcon(QIcon::fromTheme("user-properties"));

    DownloadSettingsTab *downloadsTab = new DownloadSettingsTab(m_session, this);
    CategorySettingsTab *categoriesTab = new CategorySettingsTab(m_session, this);
    AccountSettingsTab *accountsTab = new AccountSettingsTab(m_session, this);
    CaptchaSettingsTab *captchaTab = new CaptchaSettingsTab(m_session, this);

    QStackedWidget *stackedWidget = new QStackedWidget(this);
    stackedWidget->addWidget(downloadsTab);
    stackedWidget->addWidget(categoriesTab);
    stackedWidget->addWidget(accountsTab);
    stackedWidget->addWidget(captchaTab);

    PluginSettingsModel *model = new PluginSettingsModel(this);

    for (int i = 0; i < model->rowCount(); i++) {
        QModelIndex index = model->index(i);
        QListWidgetItem *item = new QListWidgetItem(QIcon("/opt/qdl/icons/" + model->data(index, PluginSettingsModel::PluginIconRole).toString()),
                                                    model->data(index, PluginSettingsModel::PluginNameRole).toString());
        listWidget->addItem(item);
        PluginSettingsTab *tab = new PluginSettingsTab(model->data(index, PluginSettingsModel::FileNameRole).toString(), this);
        stackedWidget->addWidget(tab);
    }

    QDialogButtonBox *buttonBox = new QDialogButtonBox(QDialogButtonBox::Ok, Qt::Horizontal, this);

    QGridLayout *grid = new QGridLayout(this);
    grid->addWidget(listWidget, 0, 0);
    grid->addWidget(stackedWidget, 0, 1);
    grid->addWidget(buttonBox, 1, 1);

    this->connect(listWidget, SIGNAL(currentRowChanged(int)), stackedWidget, SLOT(setCurrentIndex(int)));
    this->connect(buttonBox, SIGNAL(accepted()), this, SLOT(accept()));
    this->connect(buttonBox, SIGNAL(accepted()), downloadsTab, SLOT(saveSettings()));

    listWidget->setCurrentRow(0);
}
