#include "servicenamedelegate.h"
#include "../shared/serviceaccountsmodel.h"
#include <QPainter>

ServiceNameDelegate::ServiceNameDelegate(QObject *parent) :
    QStyledItemDelegate(parent)
{
}

void ServiceNameDelegate::paint(QPainter *painter, const QStyleOptionViewItem &option, const QModelIndex &index) const {
    QRect imageRect = option.rect;
    imageRect.setSize(QSize(19, 19));
    imageRect.moveTopLeft(QPoint(imageRect.left() + 3, imageRect.top() + 3));

    QString serviceIcon = index.data(ServiceAccountsModel::ServiceIconRole).toString();

    if (serviceIcon.isEmpty()) {
        QIcon::fromTheme("unknown").paint(painter, imageRect);
    }
    else {
        painter->drawImage(imageRect, QImage("/opt/qdl/icons/" + serviceIcon).scaled(imageRect.size(), Qt::KeepAspectRatio, Qt::SmoothTransformation));
    }

    QRect textRect = option.rect;
    textRect.setLeft(textRect.left() + 25);

    painter->drawText(textRect, Qt::AlignVCenter, index.data(ServiceAccountsModel::ServiceNameRole).toString());
}

QSize ServiceNameDelegate::sizeHint(const QStyleOptionViewItem &option, const QModelIndex &index) const {
    Q_UNUSED(index);

    return QSize(option.rect.width(), 25);
}
