#include "pluginsettingscombobox.h"
#include <QSettings>

PluginSettingsCombobox::PluginSettingsCombobox(QWidget *parent) :
    QComboBox(parent)
{
}

void PluginSettingsCombobox::setKey(const QString &key) {
    m_key = key;
}

void PluginSettingsCombobox::setDefaultValue(const QVariant &value) {
    m_default = value;
}

void PluginSettingsCombobox::load() {
    QVariant value = QSettings("QDL", "QDL").value(this->key(), this->defaultValue());

    bool found = false;
    int i = 0;

    while ((!found) && (i < this->count())) {
        found = this->itemData(i) == value;

        if (found) {
            this->setCurrentIndex(i);
        }

        i++;
    }

    if (!found) {
        this->setCurrentIndex(0);
    }

    this->connect(this, SIGNAL(currentIndexChanged(int)), this, SLOT(onCurrentIndexChanged(int)));
}

void PluginSettingsCombobox::onCurrentIndexChanged(int index) {
    if (!this->key().isEmpty()) {
        QSettings("QDL", "QDL").setValue(this->key(), this->itemData(index));
    }
}
