#ifndef CHECKURLSDIALOG_H
#define CHECKURLSDIALOG_H

#include "../shared/session.h"
#include <QDialog>
#include <QTreeWidget>
#include <QProgressBar>
#include <QLabel>
#include <QPushButton>
#include <QDialogButtonBox>
#include <QHideEvent>

class CheckUrlsDialog : public QDialog
{
    Q_OBJECT

public:
    explicit CheckUrlsDialog(Session *session, QWidget *parent = 0);

public slots:
    void checkUrls(QList<QUrl> urls);
    void checkUrls(QStringList urls);

protected:
    void hideEvent(QHideEvent *event);

private slots:
    void onUrlChecked(bool ok, const QUrl &url, const QString &service, const QString &fileName, bool done);
    void resetDialog();
    
private:
    Session *m_session;
    QTreeWidget *m_view;
    QProgressBar *m_progressBar;
    QLabel *m_infoLabel;
    QDialogButtonBox *m_buttonBox;
    QPushButton *m_okButton;
    QPushButton *m_cancelButton;
};

#endif // CHECKURLSDIALOG_H
