#include "captchasettingstab.h"
#include "decaptchanamedelegate.h"
#include "decaptchausernamedelegate.h"
#include "decaptchapassworddelegate.h"
#include <QTreeView>
#include <QPushButton>
#include <QLineEdit>
#include <QCheckBox>
#include <QGridLayout>
#include <QLabel>
#include <QFileDialog>
#include <QDesktopServices>

CaptchaSettingsTab::CaptchaSettingsTab(Session *session, QWidget *parent) :
    QWidget(parent),
    m_session(session),
    m_model(new DecaptchaAccountsModel(m_session, this)),
    m_treeView(new QTreeView(this)),
    m_editButton(new QPushButton(tr("Edit"), this)),
    m_removeButton(new QPushButton(tr("Remove"), this)),
    m_nameEdit(new QLineEdit(this)),
    m_passEdit(new QLineEdit(this)),
    m_doneButton(new QPushButton(tr("OK"), this)),
    m_checkbox(new QCheckBox(tr("Use decaptcha service"), this))
{
    QGridLayout *grid = new QGridLayout(this);
    grid->addWidget(m_treeView, 0, 0, 3, 4);
    grid->addWidget(m_editButton, 0, 4, Qt::AlignTop);
    grid->addWidget(m_removeButton, 1, 4, Qt::AlignTop);
    grid->addItem(new QSpacerItem(10, 10, QSizePolicy::Minimum, QSizePolicy::Expanding), 2, 4);
    grid->addWidget(new QLabel(tr("Add/edit account"), this), 3, 0);
    grid->addWidget(new QLabel(QString("%1:").arg(tr("Username")), this), 4, 0);
    grid->addWidget(m_nameEdit, 4, 1);
    grid->addWidget(new QLabel(QString("%1:").arg(tr("Password")), this), 5, 0);
    grid->addWidget(m_passEdit, 5, 1);
    grid->addWidget(m_doneButton, 6, 0);
    grid->addWidget(m_checkbox, 6, 1);

    m_editButton->setEnabled(false);
    m_removeButton->setEnabled(false);
    m_doneButton->setEnabled(false);

    m_treeView->setModel(m_model);
    m_treeView->setItemDelegateForColumn(0, new DecaptchaNameDelegate(m_treeView));
    m_treeView->setItemDelegateForColumn(1, new DecaptchaUsernameDelegate(m_treeView));
    m_treeView->setItemDelegateForColumn(2, new DecaptchaPasswordDelegate(m_treeView));
    m_treeView->setRootIsDecorated(false);
    m_treeView->setSelectionBehavior(QTreeView::SelectRows);
    m_treeView->setEditTriggers(QTreeView::NoEditTriggers);
    m_treeView->setExpandsOnDoubleClick(false);
    m_treeView->setItemsExpandable(false);

    this->connect(m_treeView, SIGNAL(clicked(QModelIndex)), this, SLOT(onItemClicked(QModelIndex)));
    this->connect(m_editButton, SIGNAL(clicked()), this, SLOT(editAccount()));
    this->connect(m_doneButton, SIGNAL(clicked()), this, SLOT(addAccount()));
    this->connect(m_removeButton, SIGNAL(clicked()), this, SLOT(removeAccount()));
    this->connect(m_nameEdit, SIGNAL(textChanged(QString)), this, SLOT(onAccountEditChanged()));
    this->connect(m_passEdit, SIGNAL(textChanged(QString)), this, SLOT(onAccountEditChanged()));
    this->connect(m_checkbox, SIGNAL(clicked(bool)), this, SLOT(onCheckboxClicked(bool)));
}

void CaptchaSettingsTab::onItemClicked(const QModelIndex &index) {
    m_checkbox->setChecked(m_session->settings()->decaptchaService() == index.data(DecaptchaAccountsModel::ServiceNameRole).toString());
    m_editButton->setEnabled(true);
    m_removeButton->setEnabled(true);
}

void CaptchaSettingsTab::onCheckboxClicked(bool checked) {
    if (checked) {
        QModelIndex index = m_treeView->currentIndex();

        if (index.isValid()) {
            m_session->settings()->setDecaptchaService(index.data(DecaptchaAccountsModel::ServiceNameRole).toString());
        }
    }
    else {
        m_session->settings()->setDecaptchaService(QString());
    }
}

void CaptchaSettingsTab::addAccount() {
    QModelIndex index = m_treeView->currentIndex();

    if (index.isValid()) {
        m_model->addAccount(index.data(DecaptchaAccountsModel::ServiceNameRole).toString(), m_nameEdit->text(), m_passEdit->text());
    }

    m_nameEdit->clear();
    m_passEdit->clear();
}

void CaptchaSettingsTab::removeAccount() {
    QModelIndex index = m_treeView->currentIndex();

    if (index.isValid()) {
        m_model->removeAccount(index.data(DecaptchaAccountsModel::ServiceNameRole).toString());
    }
}

void CaptchaSettingsTab::editAccount() {
    QModelIndex index = m_treeView->currentIndex();

    if (index.isValid()) {
        m_nameEdit->setText(index.data(DecaptchaAccountsModel::UsernameRole).toString());
        m_passEdit->setText(index.data(DecaptchaAccountsModel::PasswordRole).toString());
    }
}

void CaptchaSettingsTab::onAccountEditChanged() {
    m_doneButton->setEnabled((!m_nameEdit->text().isEmpty()) && (!m_passEdit->text().isEmpty()));
}
