#include "addurlsdialog.h"
#include "checkurlsdialog.h"

AddUrlsDialog::AddUrlsDialog(Session *session, QWidget *parent) :
    QDialog(parent),
    m_session(session),
    m_urlsEdit(new QTextEdit(this)),
    m_buttonBox(new QDialogButtonBox(QDialogButtonBox::Ok | QDialogButtonBox::Cancel, Qt::Horizontal, this)),
    m_grid(new QGridLayout(this))
{
    this->setWindowTitle(tr("Add URLs"));
    this->setAttribute(Qt::WA_DeleteOnClose, true);
    this->setMinimumSize(500, 300);

    m_grid->addWidget(m_urlsEdit, 0, 0);
    m_grid->addWidget(m_buttonBox, 1, 0);

    this->connect(m_buttonBox, SIGNAL(accepted()), this, SLOT(parseUrls()));
    this->connect(m_buttonBox, SIGNAL(rejected()), this, SLOT(reject()));
}

void AddUrlsDialog::parseUrls() {    
    m_session->urlChecker()->parseUrlsFromText(m_urlsEdit->toPlainText());
    this->accept();
}
