import QtQuick 1.1
import com.nokia.meego 1.0
import com.marxian.models 1.0
import "scripts/createobject.js" as ObjectCreator

MySheet {
    id: root

    property bool showFiles: false
    property string startFolder: Settings.downloadPath

    signal fileChosen(string filePath)

    function createModel() {
        fileList.model = ObjectCreator.createObject(Qt.resolvedUrl("FileListModel.qml"), fileList);
        fileList.model.folder = "file://" + startFolder;
        fileList.model.showFiles = showFiles;
    }

    Component.onCompleted: initialiseTimer.restart()

    Timer {
        id: initialiseTimer

        interval: 500
        onTriggered: createModel()
    }

    acceptButtonText: folderText.text == "" ? "" : qsTr("Done")
    rejectButtonText: qsTr("Cancel")
    onAccepted: root.fileChosen(root.showFiles ? fileList.chosenFile.slice(7) : fileList.model.folder.toString().slice(7))
    content: Item {
        anchors.fill: parent

        Label {
            id: folderText

            anchors {
                left: parent.left
                right: parent.right
                top: parent.top
                margins: 10
            }

            font.bold: true
            elide: Text.ElideRight
            color: "#0881cb"
            text: !fileList.model ? "" : showFiles ? fileList.chosenFile.slice(fileList.chosenFile.lastIndexOf("/") + 1) : fileList.model.folder.toString().slice(7)
        }

        SeparatorLabel {
            id: separator

            anchors {
                left: parent.left
                right: parent.right
                top: folderText.bottom
                margins: 10
            }

            text: showFiles ? qsTr("Files") : qsTr("Folders")
        }

        ListView {
            id: fileList

            property string chosenFile: ""

            anchors {
                top: separator.bottom
                topMargin: 10
                left: parent.left
                right: parent.right
                bottom: backButton.top
                bottomMargin: 10
            }

            clip: true
            boundsBehavior: Flickable.DragOverBounds
            delegate: FileBrowserDelegate {
                id: delegate

                onClicked: fileList.model.isFolder(index) ? fileList.model.folder = filePath : fileList.chosenFile = filePath
            }
        }

        ScrollDecorator {
            flickableItem: fileList
        }

        ToolIcon {
            id: backButton

            z: 1000
            anchors { left: parent.left; bottom: parent.bottom }
            platformIconId: "toolbar-back"
            enabled: fileList.model ? true : false
            opacity: enabled ? 1 : 0.3
            onClicked: fileList.model.folder = fileList.model.parentFolder
        }
    }

    Label {
        id: noResultsText

        anchors.centerIn: parent
        font.pixelSize: 40
        font.bold: true
        color: "#4d4d4d"
        horizontalAlignment: Text.AlignHCenter
        verticalAlignment: Text.AlignVCenter
        text: qsTr("Folder empty")
        visible: (fileList.model) && (fileList.count == 0) ? true : false
    }

    BusyIndicator {
        anchors.centerIn: parent
        visible: (!fileList.model) && (root.status === DialogStatus.Open)
        platformStyle: BusyIndicatorStyle {
            size: "large"
        }
    }    
}
