#include "searchlistmodel.h"

SearchListModel::SearchListModel(QObject *parent) :
    QSortFilterProxyModel(parent),
    m_model(new QStringListModel(this)),
    m_settings(new QSettings("Marxian", "QDL", this))
{
    this->setSourceModel(m_model);
    this->setFilterRole(Qt::DisplayRole);
    this->setDynamicSortFilter(true);

    m_settings->beginGroup("Search");
    this->setSearches(m_settings->value("recentSearches", QStringList()).toStringList());
    m_settings->endGroup();
}

SearchListModel::~SearchListModel() {
    this->saveSearches();
}

void SearchListModel::saveSearches() {
    QStringList strings;
    int i = 0;

    while ((i < 50) && (i < m_model->stringList().size())) {
        strings << m_model->stringList().at(i);
        i++;
    }

    m_settings->beginGroup("Search");
    m_settings->setValue("recentSearches", strings);
    m_settings->endGroup();
}

void SearchListModel::setSearches(const QStringList &searches) {
    m_model->setStringList(searches);
}

void SearchListModel::setQuery(const QString &query) {
    m_query = query;
    this->setFilterRegExp(QRegExp(query, Qt::CaseInsensitive, QRegExp::FixedString));
    emit dataChanged(index(0, 0), index(rowCount() - 1, 0));
}

QString SearchListModel::regexMatch(QString str) const {
    QRegExp re(filterRegExp());

    if ((!re.isEmpty()) && (re.indexIn(str) > -1)) {
        str.replace(re, "<b>" + re.cap() + "</b>");
    }

    return str;
}

void SearchListModel::addSearch(const QString &query) {
    this->beginResetModel();
    int i = m_model->stringList().indexOf(QRegExp(query, Qt::CaseInsensitive, QRegExp::FixedString));

    if (i >= 0) {
        this->removeRow(i);
    }

    this->insertRow(0);
    this->setData(index(0, 0), query, 0);
    this->endResetModel();
}

void SearchListModel::removeSearch(int row) {
    this->removeRow(row);
}

void SearchListModel::clearSearches() {
    this->beginResetModel();
    m_model->setStringList(QStringList());
    this->endResetModel();

    emit alert(tr("Search history cleared"));
}

QVariant SearchListModel::data(const QModelIndex &index, int role) const {
    return this->query().isEmpty() ? m_model->data(this->mapToSource(index), role) : this->regexMatch(m_model->data(this->mapToSource(index), role).toString());
}
