#include "transferselectiondelegate.h"
#include "../shared/transfermodel.h"
#include "../shared/paths.h"
#include <QPainter>

TransferSelectionDelegate::TransferSelectionDelegate(QObject *parent) :
    QStyledItemDelegate(parent)
{
}

void TransferSelectionDelegate::paint(QPainter *painter, const QStyleOptionViewItem &option, const QModelIndex &index) const {
    bool checked = index.data(TransferModel::SelectedRole).toBool();

    if (((option.state) & (QStyle::State_Selected)) || (checked)) {
        painter->drawImage(option.rect, QImage("/etc/hildon/theme/images/TouchListBackgroundPressed.png"));
    }
    else {
        painter->drawImage(option.rect, QImage("/etc/hildon/theme/images/TouchListBackgroundNormal.png"));
    }

    QRect imageRect = option.rect;
    imageRect.moveTopLeft(QPoint(imageRect.left() + 5, imageRect.top() + 16));
    imageRect.setSize(QSize(48, 48));

    QString serviceIcon = index.data(TransferModel::ServiceIconRole).toString();

    if (serviceIcon.isEmpty()) {
        QIcon::fromTheme("filemanager_unknown_file").paint(painter, imageRect);
    }
    else {
        painter->drawImage(imageRect, QImage(ICON_PATH_MAEMO_5 + serviceIcon).scaled(imageRect.size(), Qt::KeepAspectRatio, Qt::SmoothTransformation));
    }

    if (checked) {
        imageRect.moveRight(option.rect.right() - 5);
        painter->drawImage(imageRect, QImage("/usr/share/icons/hicolor/48x48/hildon/widgets_tickmark_grid.png"));
    }

    QRect textRect = option.rect;
    textRect.setLeft(textRect.left() + 58);
    textRect.setRight(checked ? textRect.right() - 58 : textRect.right() - 5);

    painter->drawText(textRect, Qt::AlignVCenter, index.data(TransferModel::FileNameRole).toString());
}

QSize TransferSelectionDelegate::sizeHint(const QStyleOptionViewItem &option, const QModelIndex &index) const {
    Q_UNUSED(index);

    return QSize(option.rect.width(), 80);
}
