#include "transfermovedelegate.h"
#include "../shared/transfermodel.h"
#include "../shared/paths.h"
#include <QPainter>

TransferMoveDelegate::TransferMoveDelegate(QObject *parent) :
    QStyledItemDelegate(parent)
{
}

void TransferMoveDelegate::paint(QPainter *painter, const QStyleOptionViewItem &option, const QModelIndex &index) const {
    if ((option.state) & (QStyle::State_Selected)) {
        painter->drawImage(option.rect, QImage("/etc/hildon/theme/images/TouchListBackgroundPressed.png"));
    }
    else {
        painter->drawImage(option.rect, QImage("/etc/hildon/theme/images/TouchListBackgroundNormal.png"));
    }

    QRect indexRect = option.rect;
    indexRect.moveLeft(indexRect.left() + 5);
    indexRect.setWidth(40);

    painter->drawText(indexRect, Qt::AlignCenter, QString::number(index.row() + 1));

    QRect imageRect = option.rect;
    imageRect.moveTopLeft(QPoint(imageRect.left() + 50, imageRect.top() + 16));
    imageRect.setSize(QSize(48, 48));

    QString serviceIcon = index.data(TransferModel::ServiceIconRole).toString();

    if (serviceIcon.isEmpty()) {
        QIcon::fromTheme("filemanager_unknown_file").paint(painter, imageRect);
    }
    else {
        painter->drawImage(imageRect, QImage(ICON_PATH_MAEMO_5 + serviceIcon).scaled(imageRect.size(), Qt::KeepAspectRatio, Qt::SmoothTransformation));
    }

    QRect textRect = option.rect;
    textRect.setLeft(textRect.left() + 103);
    textRect.setRight(textRect.right() - 5);

    painter->drawText(textRect, Qt::AlignVCenter, index.data(TransferModel::FileNameRole).toString());
}

QSize TransferMoveDelegate::sizeHint(const QStyleOptionViewItem &option, const QModelIndex &index) const {
    Q_UNUSED(index);

    return QSize(option.rect.width(), 80);
}
