#ifndef SERVICEACCOUNTSDIALOG_H
#define SERVICEACCOUNTSDIALOG_H

#include <QDialog>

class Session;
class ServiceAccountsModel;
class QTreeView;
class QMenu;
class QModelIndex;

class ServiceAccountsDialog : public QDialog
{
    Q_OBJECT

public:
    explicit ServiceAccountsDialog(Session *session, QWidget *parent = 0);
    
private slots:
    void showContextMenu(const QPoint &pos);
    void addAccount(const QString &serviceName, const QString &username, const QString &password);
    void removeAccount();
    void onItemClicked(const QModelIndex &index);

private:
    Session *m_session;
    ServiceAccountsModel *m_model;
    QTreeView *m_treeView;
    QMenu *m_contextMenu;
};

#endif // SERVICEACCOUNTSDIALOG_H
