#ifndef PLUGINSETTINGSSLIDER_H
#define PLUGINSETTINGSSLIDER_H

#include <QSlider>
#include <QVariant>

class PluginSettingsSlider : public QSlider
{
    Q_OBJECT

public:
    explicit PluginSettingsSlider(QWidget *parent = 0);
    inline QString key() const { return m_key; }
    inline QVariant defaultValue() const { return m_default; }
    
public slots:
    void setKey(const QString &key);
    void setDefaultValue(const QVariant &value);
    void load();

private slots:
    void onReleased();

private:
    QString m_key;
    QVariant m_default;
};

#endif // PLUGINSETTINGSSLIDER_H
