#include "pluginsettingsdelegate.h"
#include "../shared/pluginsettingsmodel.h"
#include "../shared/paths.h"
#include <QPainter>

PluginSettingsDelegate::PluginSettingsDelegate(QObject *parent) :
    QStyledItemDelegate(parent)
{
}

void PluginSettingsDelegate::paint(QPainter *painter, const QStyleOptionViewItem &option, const QModelIndex &index) const {
    if ((option.state) & (QStyle::State_Selected)) {
        painter->drawImage(option.rect, QImage("/etc/hildon/theme/images/TouchListBackgroundPressed.png"));
    }

    QRect imageRect = option.rect;
    imageRect.setSize(QSize(48, 48));
    imageRect.moveTopLeft(QPoint(imageRect.left() + 5, imageRect.top() + 16));

    QString icon = index.data(PluginSettingsModel::PluginIconRole).toString();

    if (icon.isEmpty()) {
        QIcon::fromTheme("unknown").paint(painter, imageRect);
    }
    else {
        painter->drawImage(imageRect, QImage(ICON_PATH_MAEMO_5 + icon).scaled(imageRect.size(), Qt::KeepAspectRatio, Qt::SmoothTransformation));
    }

    QRect textRect = option.rect;
    textRect.setLeft(textRect.left() + 63);
    textRect.setRight(textRect.right() - 5);

    painter->drawText(textRect, Qt::AlignVCenter, index.data(PluginSettingsModel::PluginNameRole).toString());
}

QSize PluginSettingsDelegate::sizeHint(const QStyleOptionViewItem &option, const QModelIndex &index) const {
    Q_UNUSED(index);

    return QSize(option.rect.width(), 80);
}
