#ifndef DECAPTCHAACCOUNTSDIALOG_H
#define DECAPTCHAACCOUNTSDIALOG_H

#include <QDialog>

class Session;
class DecaptchaAccountsModel;
class QTreeView;
class QModelIndex;
class QMenu;

class DecaptchaAccountsDialog : public QDialog
{
    Q_OBJECT

public:
    explicit DecaptchaAccountsDialog(Session *session, QWidget *parent = 0);

private slots:
    void showContextMenu(const QPoint &pos);
    void addAccount(const QString &serviceName, const QString &username, const QString &password);
    void removeAccount();
    void onItemClicked(const QModelIndex &index);

private:
    Session *m_session;
    DecaptchaAccountsModel *m_model;
    QTreeView *m_treeView;
    QMenu *m_contextMenu;
};

#endif // DECAPTCHAACCOUNTSDIALOG_H
